/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryInfo {
    public final String name;
    public final int count;
    public final int minLength;
    public final int maxLength;
    public final long sum;
    public final int median;
    public final int average;

    public CategoryInfo(String name, List<Integer> lengths) {
        this.name = name;
        if (lengths == null) {
            lengths = Collections.emptyList();
        }
        this.count = lengths.size();
        int min = this.count > 0 ? Integer.MAX_VALUE : 0;
        int max = this.count > 0 ? Integer.MIN_VALUE : 0;
        long sum = 0L;
        for (int length : lengths) {
            min = Math.min(min, length);
            max = Math.max(max, length);
            sum += (long)length;
        }
        this.minLength = min;
        this.maxLength = max;
        this.sum = sum;
        if (this.count > 0) {
            Collections.sort(lengths);
            int mid = this.count / 2;
            int median = this.count % 2 == 1 || lengths.size() == 1 ? lengths.get(mid) : (lengths.get(mid - 1) + lengths.get(mid)) / 2;
            this.median = median;
        } else {
            this.median = 0;
        }
        this.average = this.count > 0 ? (int)(sum / (long)this.count) : 0;
    }
}

